# CAUTION: PYTHON VODOO AHEAD!

## Utilização

Esse módulo pode ser utilizado para consumir (apenas função read) a API dos SIGs.

### Configuração

Instale o módulo...


### Configurações

No settings do seu projeto, adicione as seguintes propriedades:
 * SIGS_API_BASE_URL = url de consulta da API
 * SIGS_API_AUTHENTICATION_URL = url de autenticação da API
 * SIGS_API_KEY = chave de API 
 * SIGS_API_CLIENT_ID = usuário
 * SIGS_API_CLIENT_SECRET = senha

### No seu arquivo models

Importe:

```python
from api_sigs.models import SIGsAPIField, SIGsAPIModel, SIGsAPIForeignKey
```

Defina as classes:

```python
class UnidadeFederativaModel(SIGsAPIModel):
    descricao = SIGsAPIField()
    sigla = SIGsAPIField()
    id_pais = SIGsAPIField()
    id_unidade_federativa = SIGsAPIField()
    class Meta:
        servico = "comum"
        recurso = "unidades-federativas"

class MunicipioModel(SIGsAPIModel):
    nome_municipio = SIGsAPIField()
    id_municipio = SIGsAPIField()
    unidade_federativa = SIGsAPIForeignKey(UnidadeFederativaModel)
    class Meta:
        servico = "comum"
        recurso = "municipios"
```

# ideias

Ideias de apis para consumir:
calendario da universidade (feriados etc.)
calendário acadêmico
livros da biblioteca, trabalhos de conclusão de curso
editais de concursos
cursos, componentes curriculares
eventos
telefones - ramais

