#!/usr/bin/env bash

CONTAINER_ID=$(docker ps | grep railsserver | awk '{print $1}')

if [ -z "$CONTAINER_ID" ]
then
      echo "Rails Container is not running"      
else
      BASE_DIR_ZAMMAD=$(docker inspect $CONTAINER_ID | grep '"Source":' | awk {'print $2'} | tr -d '"' | tr -d ',')
      
      echo -e "[DOWNLOADING IMAGES...] $(date)"
      cp customized-files/UFRPE_Digital-08.png $BASE_DIR_ZAMMAD/public/assets/images/UFRPE_Digital-08.png
      cp customized-files/std-fundo_azulescuro.JPG $BASE_DIR_ZAMMAD/public/assets/images/std-fundo_azulescuro.JPG
      
      echo -e "\n\n[COPYING CUSTOMIZED FILES TO CONTAINER'S VOLUME...] $(date)"
      cp customized-files/index.html.erb $BASE_DIR_ZAMMAD/app/views/knowledge_base/public/categories/index.html.erb
      cp customized-files/dashboard.jst.eco $BASE_DIR_ZAMMAD/app/assets/javascripts/app/views/dashboard.jst.eco
      cp customized-files/login.jst.eco $BASE_DIR_ZAMMAD/app/assets/javascripts/app/views/login.jst.eco
      cp customized-files/custom.css $BASE_DIR_ZAMMAD/app/assets/stylesheets/custom/custom.css
      
      echo -e "\n\n[INSTALLING NODEJS...] $(date)"
      docker exec -u root $CONTAINER_ID bash -c "apt update && apt install -y nodejs"
      
      echo -e "\n\n[COMPILING ASSETS...] $(date)"
      docker exec $CONTAINER_ID rake assets:precompile

      echo -e "\n\n[RESTARTING CONTAINER...] $(date)"
      docker restart $CONTAINER_ID

      echo -e "\n\n[FINISHED!] $(date)"
fi