# Script Customização Central de Serviços Digitais - Zammad

Esse repositório contém o script para customizar alguns arquivos da instalação do Zammad.

## Uso

Esse script deve ser usado em qualquer momento que o zammad for resetado ou atualizado. Esse script deve ser executado na máquina host que estará executando os container do zammad, principalmente o container `railsserver`.


## EXTRA - Como Atualizar o Zammad

Siga os passos a seguir para atualizar para a versão mais recente do zammad via docker-compose.

1. Acesse o terminal do container que tenha o prefixo railsserver_1 para limpar o cache:
```bash
foo@bar:~$ docker exec -it xxx_railsserver_1 bash

zammad@xxx_railsserver_1:~$ rails r "Cache.clear"
zammad@xxx_railsserver_1:~$ exit
```

2. Após sair do terminal do container, descubra onde o volume deste mesmo container está montado:
```bash
foo@bar:~$ docker inspect xxx_railsserver_1
```
Será apresentando uma estrutura similar a um json, e na seção `Mount`, o atributo `Source` indicará o local que o volume estará montado no host.

Exemplo:
```bash
"Mounts": [
            {
                "Type": "volume",
                "Name": "zammad-docker-compose_zammad-data",
                "Source": "/var/snap/docker/common/var-lib-docker/volumes/zammad-docker-compose_zammad-data/_data",
                "Destination": "/opt/zammad",
                "Driver": "local",
                "Mode": "rw",
                "RW": true,
                "Propagation": ""
            }
        ],
```

Assumindo que o volume está montado em `/var/snap/docker/common/var-lib-docker/volumes/zammad-docker-compose_zammad-data/_data`, acesse-o:
```bash
foo@bar:~$ cd /var/snap/docker/common/var-lib-docker/volumes/zammad-docker-compose_zammad-data/_data
```

3. Entre em `tmp/cache` e remova todos os arquivos e diretórios que estiverem dentro.

4. Agora volte ao diretório `zammad-docker-compose`, pare os containers utilizando o comando `docker-compose`, busque os novos arquivos do `Github`, busque as novas imagens com o `docker-compose`, e levante os novos containers.

```bash
foo@bar:~$ docker-compose stop
foo@bar:~$ git pull
foo@bar:~$ docker-compose pull
foo@bar:~$ docker-compose up
```

## ERROS

Observe o log do container xxx_init_1, ele é responsável por inicializar o zammad. Alguns possíveis erros é por falta de permissão para deletar certos arquivos, será necessário que sejam excluídos manualmente. Por exemplo, o diretório `ls /var/snap/docker/common/var-lib-docker/volumes/zammad-docker-compose_zammad-data/_data/public/assets/app/views/` deve estar vazio.