#!/usr/bin/env bash

CONTAINER_ID=$(docker ps | grep railsserver | awk '{print $1}')

if [ -z "$CONTAINER_ID" ]
then
      echo "Rails Container is not running"      
else      
      docker exec $CONTAINER_ID sed -ie '4d' /opt/zammad/app/assets/javascripts/app/views/login.jst.eco
      docker exec $CONTAINER_ID sed -i '4 a<div class="message_std"><p>Prezado usuário, antes de abrir um chamado, favor, verificar se sua dúvida está respondida na <a href="https:\/\/ajuda.ufrpe.br" target="_blank">Central de Ajuda UFRPE<\/a>. Caso ainda seja necessário abrir um chamado, observar as informações Requeridas no <a href="https:\/\/servicosdigitais.ufrpe.br\/help\/pt-br" target="_blank">Catálogo de Serviços Digitais<\/a>.<\/p><\/div>' /opt/zammad/app/assets/javascripts/app/views/login.jst.eco
      docker exec $CONTAINER_ID sed -ie '4d' /opt/zammad/app/assets/javascripts/app/views/dashboard.jst.eco
      docker exec $CONTAINER_ID sed -i '6 i<h3 style="text-align: center; font-size: 40px;">Catálogo de Serviços Digitais<\/h3>' /opt/zammad/app/views/knowledge_base/public/categories/index.html.erb
      
      wget --output-document=UFRPE_Digital-08.png "https://drive.google.com/uc?export=download&id=1iDu4B-bPFDd7ZeHliJIfJmpjSII44Ikv"
      wget --output-document=std-fundo_azulescuro.JPG "https://drive.google.com/uc?export=download&id=19fMTOD2eXeC_Tbe71-9p5jLXeqQ7jek3"
      
      docker cp UFRPE_Digital-08.png $CONTAINER_ID:/opt/zammad/public/assets/images/UFRPE_Digital-08.png
      docker cp std-fundo_azulescuro.JPG $CONTAINER_ID:/opt/zammad/public/assets/images/std-fundo_azulescuro.JPG

      docker exec $CONTAINER_ID sed -ie '77,82d' /opt/zammad/app/assets/javascripts/app/views/login.jst.eco
      docker exec $CONTAINER_ID sed -i '77 i<p> O cadastro de usuário é feito automaticamente após o registro de vínculo na instituição nos sistemas de gestão da UFRPE. Para cadastrar uma senha siga as orientações <a href="https:\/\/app-faq.tallos.com.br/ufrpe\/article\/como-criar-ou-recuperar-a-minha-senha-do-portal-da-central-de-servicos-digitais" target="_blank">aqui<\/a>. <br><br><a href="https:\/\/servicosdigitais.ufrpe.br\/#password_reset" target="_blank">Cadastrar Senha<\/a><\/p>' /opt/zammad/app/assets/javascripts/app/views/login.jst.eco
      
      docker exec $CONTAINER_ID sed -ie '88,90d' /opt/zammad/app/assets/javascripts/app/views/login.jst.eco
      docker exec $CONTAINER_ID sed -i '88 i<a href="http:\/\/digital.ufrpe.br" target="_blank"><img src="assets\/images\/UFRPE_Digital-08.png" style="width: 150px;" \/><\/a>' /opt/zammad/app/assets/javascripts/app/views/login.jst.eco
      docker exec $CONTAINER_ID sed -i '89 i<a href="http:\/\/std.ufrpe.br" target="_blank"><img src="assets\/images\/std-fundo_azulescuro.JPG" style="width: 60px;" \/><\/a>' /opt/zammad/app/assets/javascripts/app/views/login.jst.eco
      
      docker exec $CONTAINER_ID touch /opt/zammad/app/assets/stylesheets/custom/custom.css
      docker exec $CONTAINER_ID bash -c "echo '.login { background: #0B2341; }' > /opt/zammad/app/assets/stylesheets/custom/custom.css"
      docker exec $CONTAINER_ID bash -c "echo '.message_std { background: #FFE8AA; border-radius: 8px; }' >> /opt/zammad/app/assets/stylesheets/custom/custom.css"
      docker exec $CONTAINER_ID bash -c "echo '.message_std p { padding: 10px 0px; }' >> /opt/zammad/app/assets/stylesheets/custom/custom.css"
      
      docker exec -u root $CONTAINER_ID bash -c "apt update && apt install -y nodejs"
      docker exec $CONTAINER_ID rake assets:precompile

      docker restart $CONTAINER_ID

fi