#!/usr/bin/env bash

CONTAINER_ID=$(docker ps | grep railsserver | awk '{print $1}')

if [ -z "$CONTAINER_ID" ]
then
      echo "Rails Container is not running"      
else
      docker exec $CONTAINER_ID sed -i.bak -e '4d' /opt/zammad/app/assets/javascripts/app/views/dashboard.jst.eco

      wget --output-document=UFRPE_Digital-08.png "https://drive.google.com/uc?export=download&id=1iDu4B-bPFDd7ZeHliJIfJmpjSII44Ikv"
      wget --output-document=std-fundo_azulescuro.JPG "https://drive.google.com/uc?export=download&id=19fMTOD2eXeC_Tbe71-9p5jLXeqQ7jek3"

      docker cp UFRPE_Digital-08.png $CONTAINER_ID:/opt/zammad/public/assets/images/UFRPE_Digital-08.png
      docker cp std-fundo_azulescuro.JPG $CONTAINER_ID:/opt/zammad/public/assets/images/std-fundo_azulescuro.JPG

      cat index.html.erb | sudo docker exec -i $CONTAINER_ID bash -c "cat > /opt/zammad/app/views/knowledge_base/public/categories/index.html.erb"
      cat login.jst.eco | sudo docker exec -i $CONTAINER_ID bash -c "cat > /opt/zammad/app/assets/javascripts/app/views/login.jst.eco"
      cat custom.css | sudo docker exec -i $CONTAINER_ID bash -c "cat > /opt/zammad/app/assets/stylesheets/custom/custom.css"

      docker exec -u root $CONTAINER_ID bash -c "apt update && apt install -y nodejs"
      docker exec $CONTAINER_ID bash -c "rake assets:precompile"
      docker restart $CONTAINER_ID
fi