#!/usr/bin/env bash

CONTAINER_ID=$(docker ps | grep railsserver | awk '{print $1}')

if [ -z "$CONTAINER_ID" ]
then
      echo "Rails Container is not running"      
else
      BASE_DIR_ZAMMAD=$(docker inspect $CONTAINER_ID | grep '"Source":' | awk {'print $2'} | tr -d '"' | tr -d ',')

      docker exec $CONTAINER_ID sed -i.bak -e '4d' /opt/zammad/app/assets/javascripts/app/views/dashboard.jst.eco
      
      mv index.html.erb $BASE_DIR_ZAMMAD/app/views/knowledge_base/public/categories/index.html.erb
      
      wget --output-document=UFRPE_Digital-08.png "https://drive.google.com/uc?export=download&id=1iDu4B-bPFDd7ZeHliJIfJmpjSII44Ikv"
      wget --output-document=std-fundo_azulescuro.JPG "https://drive.google.com/uc?export=download&id=19fMTOD2eXeC_Tbe71-9p5jLXeqQ7jek3"
      
      mv UFRPE_Digital-08.png $BASE_DIR_ZAMMAD/public/assets/images/UFRPE_Digital-08.png
      mv std-fundo_azulescuro.JPG $BASE_DIR_ZAMMAD/public/assets/images/std-fundo_azulescuro.JPG

      mv login.jst.eco $BASE_DIR_ZAMMAD/app/assets/javascripts/app/views/login.jst.eco
      
      mv custom.css $BASE_DIR_ZAMMAD/app/assets/stylesheets/custom/
      
      docker exec -u root $CONTAINER_ID bash -c "apt update"
      docker exec -u root $CONTAINER_ID bash -c "apt install nodejs"
      docker exec -u root $CONTAINER_ID bash -c "rake assets:precompile"

      docker restart $CONTAINER_ID
fi