# Script Customização Central de Serviços Digitais - Zammad

Esse repositório contém scripts para atualizar e customizar alguns arquivos e configurações da instalação do Zammad.

```bash
.
├── layout-customization # Folder that has files to customize the UI of Zammad
│    ├── customized-files # Folder that has the customized files
│    │     ├── custom.css # CSS file responsible for adding color to the login page
│    │     ├── dashboard.jst.eco # File responsible for removing the First Steps tab from the logged page
│    │     ├── index.html.erb # File responsible for adding title to the Knowledge base
│    │     ├── login.jst.eco # File responsible for adding text and images to the login page
│    │     ├── std-fundo_azulescuro.JPG # Logo of STD
│    │     ├── UFRPE_Digital-08.png # Logo of UFRPE Digital
│    │     └── layout-std-customization.sh #
│    └── layout-std-customization.sh # Script to customize to the UI of Zammad
├── settings-customization # Folder that has files to customize the settings of Zammad
│    ├── add_new_states.rb # ruby file with commands to add new states to the system
│    ├── filter_states.rb # ruby file with commands to filter which states customers can add to tickets 
│    └── update-zammad.sh # Script to update to the newest version of Zammad
├── update-zammad # Folder that has the update-zammad.sh
│    └── update-zammad.sh # Script to update to the newest version of Zammad
└── README.md # This file
```


## Uso

Esses scripts devem ser usados em qualquer momento que o zammad for resetado ou atualizado. Esses scripts devem ser executado na máquina host que estará executando os container do zammad, principalmente o container `railsserver`.

## EXTRA - Como Atualizar o Zammad

Siga os passos a seguir ou execute o script `update-zammad/update-zammad.sh` para atualizar para a versão mais recente do zammad via docker-compose.

1. Acesse o terminal do container que tenha o prefixo railsserver_1 para limpar o cache:
```bash
foo@bar:~$ docker exec -it xxx_railsserver_1 bash

zammad@xxx_railsserver_1:~$ rails r "Cache.clear"
zammad@xxx_railsserver_1:~$ exit
```

2. Após sair do terminal do container, descubra onde o volume deste mesmo container está montado:
```bash
foo@bar:~$ docker inspect xxx_railsserver_1
```
Será apresentando uma estrutura similar a um json, e na seção `Mount`, o atributo `Source` indicará o local que o volume estará montado no host.

Exemplo:
```bash
"Mounts": [
            {
                "Type": "volume",
                "Name": "zammad-docker-compose_zammad-data",
                "Source": "/var/snap/docker/common/var-lib-docker/volumes/zammad-docker-compose_zammad-data/_data",
                "Destination": "/opt/zammad",
                "Driver": "local",
                "Mode": "rw",
                "RW": true,
                "Propagation": ""
            }
        ],
```

Assumindo que o volume está montado em `/var/snap/docker/common/var-lib-docker/volumes/zammad-docker-compose_zammad-data/_data`, acesse-o:
```bash
foo@bar:~$ cd /var/snap/docker/common/var-lib-docker/volumes/zammad-docker-compose_zammad-data/_data
```

3. Entre em `tmp/cache` e `public/assets/app/views` e remova todos os arquivos e diretórios que estiverem dentro. Esses dois diretórios devem estar vazios durante a atualização do zammad.

4. Agora volte ao diretório `zammad-docker-compose`, pare os containers utilizando o comando `docker-compose`, busque os novos arquivos do `Github`, busque as novas imagens com o `docker-compose`, e levante os novos containers.

```bash
foo@bar:~$ docker-compose stop
foo@bar:~$ git pull
foo@bar:~$ docker-compose pull
foo@bar:~$ docker-compose up
```