#!/usr/bin/env bash

CONTAINER_RAILSSERVER_ID=$(docker ps | grep railsserver | awk '{print $1}')
CONTAINER_NGINX_ID=$(docker ps | grep nginx | awk '{print $1}')
CONTAINER_POSTGRESQL_ID=$(docker ps | grep postgresql_1 | awk '{print $1}')

if [ -z "$CONTAINER_RAILSSERVER_ID" ]
then
      echo "Rails Container is not running"
else
      echo "[INCREASING MAX CONNECTIONS POSTGRESQL...] $(date)"
      docker exec -u root $CONTAINER_POSTGRESQL_ID /bin/sh -c "sed -i '/max_connections/c\max_connections = 2000' /var/lib/postgresql/data/postgresql.conf"
      docker restart $CONTAINER_POSTGRESQL_ID
      sleep 10

      BASE_DIR_ZAMMAD=$(docker inspect $CONTAINER_RAILSSERVER_ID | grep '"Source":' | awk {'print $2'} | tr -d '"' | tr -d ',')

      echo "[COPYING CUSTOMIZED FILES TO CONTAINER'S VOLUME...] $(date)"
      cp customized-files/UFRPE_Digital-08.png $BASE_DIR_ZAMMAD/public/assets/images/UFRPE_Digital-08.png
      cp customized-files/std-fundo_azulescuro.JPG $BASE_DIR_ZAMMAD/public/assets/images/std-fundo_azulescuro.JPG
      cp customized-files/index.html.erb $BASE_DIR_ZAMMAD/app/views/knowledge_base/public/categories/index.html.erb
      cp customized-files/dashboard.jst.eco $BASE_DIR_ZAMMAD/app/assets/javascripts/app/views/dashboard.jst.eco
      cp customized-files/login.jst.eco $BASE_DIR_ZAMMAD/app/assets/javascripts/app/views/login.jst.eco
      cp customized-files/custom.css $BASE_DIR_ZAMMAD/app/assets/stylesheets/custom/custom.css

      echo "[INSTALLING NODEJS...] $(date)"
      docker exec -u root $CONTAINER_RAILSSERVER_ID bash -c "apt-get update && apt-get install -y nodejs"

      echo "[COMPILING ASSETS...] $(date)"
      docker exec $CONTAINER_RAILSSERVER_ID rake assets:precompile

      echo "[RESTARTING RAILS SERVER CONTAINER...] $(date)"
      docker restart $CONTAINER_RAILSSERVER_ID

      echo "[RESTARTING NGINX CONTAINER...] $(date)"
      docker restart $CONTAINER_NGINX_ID

      echo "[FINISHED!] $(date)"
fi
