#!/usr/bin/env bash

# script para adicionar novos estados ao Zammad
# os novos estados adicionados são: pendente, aguardando resposta, resolvido e retorno

CONTAINER_RAILSSERVER_ID=$(docker ps | grep railsserver | awk '{print $1}')

while getopts ":haf-:" opt; do
    case ${opt} in
        h) 
            echo ''
            echo 'Usage:  ./settings-std-customization.sh [OPTIONS]'
            echo ''
            echo 'script para adicionar novos estados ao Zammad, deve ser executado no host, e não nos containers.'
            echo ''
            echo 'Options:'
            echo '   -a, --add-new-states     Adiciona novos estados ao Zammad da STD. Os novos chamados são:'
            echo '                            pendente, aguardando resposta, resolvido e retorno. Também'
            echo '                            os adiciona na UI e filtra para qual estado os usuários'
            echo '                            podem atualizar o chamado(i.e. fechado).'
            echo '   -f, --filter-states      Apenas filtra para qual estado os usuários'
            echo '                            podem atualizar o chamado (i.e. fechado).'
            echo '   -v, --version            Print version information and quit'
            exit 1
            ;;
        a)
            # adicionar novos estados
            echo "[$(date)] Adicionando Novos Estados..."
            docker exec -u root $CONTAINER_RAILSSERVER_ID rails r add_new_states.rb
            echo "[$(date)] Novos Estados Adicionados!"
            echo ""
            echo "[$(date)] Reconstruindo index Elastichsearch..."
            # reconstrói o index do elasticsearch
            docker exec $CONTAINER_RAILSSERVER_ID rails r "Setting.set('es_url','http://zammad-docker-compose_zammad-elasticsearch_1:9200')"
            docker exec $CONTAINER_RAILSSERVER_ID rake zammad:searchindex:rebuild
            echo "[$(date)] Index Elastichsearch Recontruído!"
            exit 1
            ;;
        f)
            # filtra quais estados o usuário pode usar
            echo "[$(date)] Filtrando os Estados..."
            docker exec -u root $CONTAINER_RAILSSERVER_ID rails r filter_states.rb
            echo "[$(date)] Filtro Completo!"
            echo ""
            echo "[$(date)] Reconstruindo index Elastichsearch..."
            # reconstrói o index do elasticsearch
            docker exec $CONTAINER_RAILSSERVER_ID rails r "Setting.set('es_url','http://zammad-docker-compose_zammad-elasticsearch_1:9200')"
            docker exec $CONTAINER_RAILSSERVER_ID rake zammad:searchindex:rebuild
            echo "[$(date)] Index Elastichsearch Recontruído!"
            exit 1
            ;;
        -)
            case ${OPTARG} in
                "add-new-states")
                    # adicionar novos estados
                    echo "[$(date)] Adicionando Novos Estados..."
                    docker exec -u root $CONTAINER_RAILSSERVER_ID rails r add_new_states.rb
                    echo "[$(date)] Novos Estados Adicionados!"
                    echo ""
                    echo "[$(date)] Reconstruindo index Elastichsearch..."
                    # reconstrói o index do elasticsearch
                    docker exec $CONTAINER_RAILSSERVER_ID rails r "Setting.set('es_url','http://zammad-docker-compose_zammad-elasticsearch_1:9200')"
                    docker exec $CONTAINER_RAILSSERVER_ID rake zammad:searchindex:rebuild
                    echo "[$(date)] Index Elastichsearch Recontruído!"
                    exit 1
                    ;;
                "--filter-states")
                    # filtra quais estados o usuário pode usar
                    echo "[$(date)] Filtrando os Estados..."
                    docker exec -u root $CONTAINER_RAILSSERVER_ID rails r filter_states.rb
                    echo "[$(date)] Filtro Completo!"
                    echo ""
                    echo "[$(date)] Reconstruindo index Elastichsearch..."
                    # reconstrói o index do elasticsearch
                    docker exec $CONTAINER_RAILSSERVER_ID rails r "Setting.set('es_url','http://zammad-docker-compose_zammad-elasticsearch_1:9200')"
                    docker exec $CONTAINER_RAILSSERVER_ID rake zammad:searchindex:rebuild
                    echo "[$(date)] Index Elastichsearch Recontruído!"
                    exit 1
                    ;;
                "help") 
                    echo ''
                    echo 'Usage:  ./settings-std-customization.sh [OPTIONS]'
                    echo ''
                    echo 'script para adicionar novos estados ao Zammad, deve ser executado no host, e não nos containers.'
                    echo ''
                    echo 'Options:'
                    echo '   -a, --add-new-states     Adiciona novos estados ao Zammad da STD. Os novos chamados são:'
                    echo '                            pendente, aguardando resposta, resolvido e retorno. Também'
                    echo '                            os adiciona na UI e filtra para qual estado os usuários'
                    echo '                            podem atualizar o chamado(i.e. fechado).'
                    echo '   -f, --filter-states      Apenas filtra para qual estado os usuários'
                    echo '                            podem atualizar o chamado (i.e. fechado).'
                    echo '   -v, --version            Print version information and quit'
                    exit 1
                    ;;
            esac
    esac
done