#!/usr/bin/env bash

CONTAINER_RAILSSERVER_ID=$(docker ps | grep railsserver | awk '{print $1}')

if [ -z "$CONTAINER_RAILSSERVER_ID" ]
then
      echo "Rails Container is not running"      
else
      echo "[$(date)] Updating Zammad"      
      docker exec $CONTAINER_RAILSSERVER_ID rails r "Cache.clear"
      
      BASE_DIR_ZAMMAD=$(docker inspect $CONTAINER_RAILSSERVER_ID | grep '"Source":' | awk {'print $2'} | tr -d '"' | tr -d ',')

      rm -rf $BASE_DIR_ZAMMAD/tmp/cache/*
      rm -rf $BASE_DIR_ZAMMAD/public/assets/app/views/*

      docker-compose -f /root/zammad-docker-compose/docker-compose.yml stop
      git pull
      docker-compose -f /root/zammad-docker-compose/docker-compose.yml pull
      docker-compose -f /root/zammad-docker-compose/docker-compose.yml up
fi

